jQuery(document).ready(function($) {
    // Vista previa en tiempo real
    function updatePreview() {
        const type = $('select[name="kdd_tormenta_objetos_settings[object_type]"]').val();
        const count = parseInt($('input[name="kdd_tormenta_objetos_settings[object_count]"]').val());
        const speed = parseInt($('input[name="kdd_tormenta_objetos_settings[object_speed]"]').val());
        const size = parseInt($('input[name="kdd_tormenta_objetos_settings[object_size]"]').val());
        
        // Mostrar información de configuración en la vista previa
        $('#kdd-tormenta-objetos-preview').html(
            '<div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); text-align: center; color: #666;">' +
            '<strong>Vista Previa</strong><br>' +
            'Tipo: ' + type + '<br>' +
            'Cantidad: ' + count + '<br>' +
            'Velocidad: ' + speed + '<br>' +
            'Tamaño: ' + size + 'px</div>'
        );
    }
    
    // Actualizar vista previa cuando cambien los valores
    $('select[name="kdd_tormenta_objetos_settings[object_type]"], input[type="range"]').on('change input', updatePreview);
    
    // Vista previa inicial
    updatePreview();
    
    // Mejorar la interfaz de los range inputs
    $('input[type="range"]').each(function() {
        const output = $(this).next('output');
        if (output.length) {
            $(this).on('input', function() {
                if ($(this).attr('name').includes('object_count')) {
                    output.text($(this).val() + ' objetos');
                } else if ($(this).attr('name').includes('object_size')) {
                    output.text($(this).val() + 'px');
                } else {
                    output.text($(this).val());
                }
            });
        }
    });
    
    // Manejar subida de imágenes personalizadas
    $('#upload_image_btn').on('click', function() {
        const fileInput = $('#custom_image_upload')[0];
        const objectType = $('#image_object_type').val();
        
        if (!fileInput.files.length) {
            alert('Por favor selecciona una imagen.');
            return;
        }
        
        const formData = new FormData();
        formData.append('action', 'kdd_upload_custom_image');
        formData.append('nonce', kddTormentaObjetosAdmin.nonce);
        formData.append('object_type', objectType);
        formData.append('custom_image', fileInput.files[0]);
        
        $('#upload_status').html('<p style="color: blue;">' + kddTormentaObjetosAdmin.uploading_text + '</p>');
        
        $.ajax({
            url: kddTormentaObjetosAdmin.ajax_url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    $('#upload_status').html('<p style="color: green;">' + response.data.message + '</p>');
                    $('#custom_image_upload').val('');
                    // Recargar la página para mostrar la nueva imagen
                    setTimeout(() => {
                        location.reload();
                    }, 1000);
                } else {
                    $('#upload_status').html('<p style="color: red;">' + response.data + '</p>');
                }
            },
            error: function() {
                $('#upload_status').html('<p style="color: red;">' + kddTormentaObjetosAdmin.error_text + '</p>');
            }
        });
    });
    
    // Manejar eliminación de imágenes
    $('.remove-image').on('click', function() {
        if (!confirm(kddTormentaObjetosAdmin.confirm_remove)) {
            return;
        }
        
        const button = $(this);
        const objectType = button.data('type');
        
        $.ajax({
            url: kddTormentaObjetosAdmin.ajax_url,
            type: 'POST',
            data: {
                action: 'kdd_remove_custom_image',
                nonce: kddTormentaObjetosAdmin.nonce,
                object_type: objectType
            },
            success: function(response) {
                if (response.success) {
                    button.closest('div').remove();
                    // Si no quedan imágenes, mostrar mensaje
                    if ($('#current_images .remove-image').length === 0) {
                        $('#current_images').html('<p>No hay imágenes personalizadas subidas.</p>');
                    }
                } else {
                    alert('Error al eliminar la imagen.');
                }
            }
        });
    });
});