/* ==========================================
   KDDMantenimiento v2.0 - Admin Scripts
   Funcionalidades JavaScript para el panel de administración
========================================== */

jQuery(document).ready(function($) {
    // Inicializar color picker
    $('.kdd-color-field').wpColorPicker();
    
    // Mostrar/ocultar campos según el tipo de fondo
    function toggleBackgroundFields() {
        var type = $('#kdd_background_type').val();
        var videoType = $('#kdd_video_type').val();
        
        // Ocultar todos los campos de fondo primero
        $('#kdd_background_image').closest('tr').hide();
        $('#kdd_video_type').closest('tr').hide();
        $('#kdd_youtube_url').closest('tr').hide();
        $('#kdd_vimeo_url').closest('tr').hide();
        $('input[name="kdd_mantenimiento_settings[background_color]"]').closest('tr').hide();
        
        // Mostrar el campo correspondiente
        if (type === 'image') {
            $('#kdd_background_image').closest('tr').show();
        } else if (type === 'video') {
            $('#kdd_video_type').closest('tr').show();
            if (videoType === 'youtube') {
                $('#kdd_youtube_url').closest('tr').show();
            } else if (videoType === 'vimeo') {
                $('#kdd_vimeo_url').closest('tr').show();
            }
        } else if (type === 'color') {
            $('input[name="kdd_mantenimiento_settings[background_color]"]').closest('tr').show();
        }
        
        // Mostrar/ocultar nota sobre móviles
        if (type === 'video') {
            $('.kdd-notice.kdd-warning').show();
        } else {
            $('.kdd-notice.kdd-warning').hide();
        }
    }
    
    // Inicializar campos al cargar
    toggleBackgroundFields();
    
    // Escuchar cambios en el tipo de fondo
    $('#kdd_background_type').on('change', toggleBackgroundFields);
    $('#kdd_video_type').on('change', toggleBackgroundFields);
    
    // Manejar upload de medios
    $('.kdd-media-btn').on('click', function(e) {
        e.preventDefault();
        
        var target = $(this).data('target');
        var type = $(this).data('type');
        var frame = wp.media({
            title: 'Seleccionar ' + (type === 'video' ? 'video' : 'imagen'),
            multiple: false,
            library: {
                type: type
            },
            button: {
                text: 'Usar este archivo'
            }
        });
        
        frame.on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            $('#' + target).val(attachment.url);
            
            // Mostrar preview
            var previewContainer = $('#' + target).closest('.kdd-media-upload').find('.kdd-preview');
            if (type === 'image') {
                previewContainer.show().find('img').attr('src', attachment.url);
            } else {
                var videoElement = previewContainer.show().find('video source');
                videoElement.attr('src', attachment.url);
                if (videoElement.length) {
                    videoElement.parent()[0].load();
                }
            }
        });
        
        frame.open();
    });
    
    // Manejar remover archivos
    $('.kdd-remove-btn').on('click', function(e) {
        e.preventDefault();
        var target = $(this).data('target');
        var previewContainer = $('#' + target).closest('.kdd-media-upload').find('.kdd-preview');
        
        $('#' + target).val('');
        previewContainer.hide();
        
        if (target === 'kdd_background_image' || target === 'kdd_logo_url' || target === 'kdd_mobile_background_image') {
            previewContainer.find('img').attr('src', '');
        } else if (target === 'kdd_background_video') {
            previewContainer.find('video source').attr('src', '');
            var videoElement = previewContainer.find('video')[0];
            if (videoElement) {
                videoElement.load();
            }
        }
    });
    
    // Probar videos
    $('.kdd-test-video').on('click', function(e) {
        e.preventDefault();
        var type = $(this).data('type');
        var urlField = type === 'youtube' ? $('#kdd_youtube_url') : $('#kdd_vimeo_url');
        var url = urlField.val();
        
        if (!url) {
            alert('Por favor, ingresa una URL de ' + (type === 'youtube' ? 'YouTube' : 'Vimeo'));
            return;
        }
        
        // Validación básica de URL
        var pattern = type === 'youtube' ? 
            /(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/ :
            /vimeo\.com\/(?:channels\/(?:\w+\/)?|groups\/(?:[^\/]*)\/videos\/|)(\d+)(?:|\/\?)/;
            
        if (!pattern.test(url)) {
            alert('La URL de ' + (type === 'youtube' ? 'YouTube' : 'Vimeo') + ' no es válida.');
            return;
        }
        
        // Extraer ID y mostrar preview
        var match = url.match(pattern);
        var videoId = match[1];
        
        var previewContainer = urlField.closest('.kdd-video-upload').find('.kdd-preview');
        var previewImage = previewContainer.find('img');
        
        if (type === 'youtube') {
            previewImage.attr('src', 'https://img.youtube.com/vi/' + videoId + '/maxresdefault.jpg');
            previewContainer.find('.description small').text('ID del video: ' + videoId);
        } else {
            // Para Vimeo, intentamos obtener el thumbnail via API
            previewImage.attr('src', '');
            previewContainer.find('.description small').text('ID del video: ' + videoId + ' (cargando vista previa...)');
            
            // Hacer AJAX call para obtener thumbnail de Vimeo
            $.getJSON('https://vimeo.com/api/v2/video/' + videoId + '.json', function(data) {
                if (data && data[0] && data[0].thumbnail_large) {
                    previewImage.attr('src', data[0].thumbnail_large);
                    previewContainer.find('.description small').text('ID del video: ' + videoId);
                }
            }).fail(function() {
                previewContainer.find('.description small').text('ID del video: ' + videoId + ' (no se pudo cargar la vista previa)');
            });
        }
        
        previewContainer.show();
        alert('✅ Video de ' + (type === 'youtube' ? 'YouTube' : 'Vimeo') + ' configurado correctamente. ID: ' + videoId);
    });
    
    // Mostrar advertencia cuando se active el modo mantenimiento
    $('input[name="kdd_mantenimiento_settings[enable_maintenance]"]').on('change', function() {
        if ($(this).is(':checked')) {
            if (confirm('⚠️ ¿Estás seguro de activar el modo mantenimiento?\n\nLos visitantes verán la página de mantenimiento hasta que lo desactives.\n\n¿Continuar?')) {
                // El checkbox ya se marca automáticamente
            } else {
                $(this).prop('checked', false);
            }
        }
    });
    
    // Validación de número de WhatsApp
    $('input[name="kdd_mantenimiento_settings[whatsapp_number]"]').on('blur', function() {
        var number = $(this).val();
        if (number && !number.match(/^\+\d{10,15}$/)) {
            alert('⚠️ El número de WhatsApp debe incluir código de país y tener entre 10-15 dígitos.\nEjemplo: +573001234567');
            $(this).focus();
        }
    });
    
    // Toggle campos de WhatsApp
    $('input[name="kdd_mantenimiento_settings[whatsapp_enabled]"]').on('change', function() {
        var whatsappFields = $('input[name="kdd_mantenimiento_settings[whatsapp_number]"]').closest('tr');
        if ($(this).is(':checked')) {
            whatsappFields.removeClass('kdd-field-disabled').addClass('kdd-field-enabled');
        } else {
            whatsappFields.removeClass('kdd-field-enabled').addClass('kdd-field-disabled');
        }
    });
    
    // Inicializar estado de campos de WhatsApp
    if (!$('input[name="kdd_mantenimiento_settings[whatsapp_enabled]"]').is(':checked')) {
        $('input[name="kdd_mantenimiento_settings[whatsapp_number]"]').closest('tr').addClass('kdd-field-disabled');
    }
    
    // Mejorar la experiencia del editor de texto
    $('.kdd-rich-text-editor').on('focus', function() {
        $(this).closest('td').addClass('textarea-focused');
    }).on('blur', function() {
        $(this).closest('td').removeClass('textarea-focused');
    });
    
    // Vista previa de redes sociales
    function updateSocialPreview() {
        var socialFields = [
            'social_instagram',
            'social_tiktok', 
            'social_facebook',
            'social_twitter'
        ];
        
        var hasSocial = false;
        socialFields.forEach(function(field) {
            var value = $('input[name="kdd_mantenimiento_settings[' + field + ']"]').val();
            if (value) {
                hasSocial = true;
            }
        });
        
        if (hasSocial) {
            $('.kdd-social-preview').show();
        } else {
            $('.kdd-social-preview').hide();
        }
    }
    
    // Inicializar vista previa de redes sociales
    updateSocialPreview();
    
    // Escuchar cambios en campos de redes sociales
    $('input[name^="kdd_mantenimiento_settings[social_"]').on('input', updateSocialPreview);
    
    // Smooth scrolling para secciones
    $('.kdd-settings-wrap h2').each(function() {
        var $h2 = $(this);
        var $tr = $h2.closest('tr');
        if ($tr.length) {
            $h2.wrap('<div class="kdd-section-header"></div>');
        }
    });
});