<?php
/**
 * KDDMantenimiento - Módulo del Editor de Texto
 * Maneja la funcionalidad del editor de texto enriquecido
 */

// Evitar acceso directo
if (!defined('ABSPATH')) {
    exit;
}

class KDDMantenimiento_Text_Editor {
    
    /**
     * Renderiza el editor de texto enriquecido
     */
    public function render_text_editor($message) {
        ob_start();
        ?>
        <div class="kdd-rich-text-editor">
            <?php
            $editor_id = 'kdd_custom_message';
            $settings = array(
                'textarea_name' => 'kdd_mantenimiento_settings[custom_message]',
                'textarea_rows' => 8,
                'media_buttons' => false,
                'tinymce' => array(
                    'toolbar1' => 'bold,italic,underline,link,unlink,bullist,numlist,alignleft,aligncenter,alignright',
                    'toolbar2' => '',
                    'content_css' => $this->get_editor_css()
                ),
                'quicktags' => false,
                'editor_height' => 200,
            );
            
            wp_editor(wp_kses_post($message), $editor_id, $settings);
            ?>
            <p class="description">Este mensaje se mostrará a los visitantes mientras el sitio está en mantenimiento. Puedes usar formato de texto enriquecido.</p>
        </div>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Obtiene el CSS para el editor
     */
    private function get_editor_css() {
        return '
            .mce-content-body {
                font-family: Arial, sans-serif;
                font-size: 14px;
                line-height: 1.6;
                color: #333;
            }
            .mce-content-body p {
                margin-bottom: 1em;
            }
            .mce-content-body ul, .mce-content-body ol {
                margin-left: 20px;
                margin-bottom: 1em;
            }
        ';
    }
    
    /**
     * Procesa y sanitiza el contenido del editor
     */
    public function sanitize_message($message) {
        // Permitir HTML básico para formato
        $allowed_html = array(
            'p' => array(
                'style' => array(),
                'class' => array(),
            ),
            'br' => array(),
            'strong' => array(),
            'em' => array(),
            'u' => array(),
            'a' => array(
                'href' => array(),
                'title' => array(),
                'target' => array(),
                'rel' => array(),
            ),
            'ul' => array(
                'class' => array(),
            ),
            'ol' => array(
                'class' => array(),
            ),
            'li' => array(
                'class' => array(),
            ),
            'span' => array(
                'style' => array(),
                'class' => array(),
            ),
        );
        
        return wp_kses($message, $allowed_html);
    }
    
    /**
     * Convierte saltos de línea en párrafos
     */
    public function format_message($message) {
        return wpautop($message);
    }
}